/*
 * Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * SPDX-License-Identifier:  GPL-2.0+
 */
#pragma once

#define HASH_SIZE                       (32)  /* SHA-256 hash size */
#define DSN_SIZE                        (16)  /* 16 bytes for DSN (plaintext) */
#define SIGNATURE_SIZE                 (256)  /* RSA PKCS1v1.5 2048bit signature size */
#define RAW_PUBLIC_KEY_LENGTH		   (256)  /* Raw binary public key size */

/* Struct required to avoid this warning about const and arrays :
 * see https://stackoverflow.com/questions/34488559/pointer-to-array-with-const-qualifier-in-c-c
 */
typedef struct { uint8_t value[HASH_SIZE];             } hash_t;
typedef struct { uint8_t value[DSN_SIZE];              } unique_tag_t;
typedef struct { uint8_t value[SIGNATURE_SIZE];        } signature_t;
typedef struct { uint8_t value[RAW_PUBLIC_KEY_LENGTH]; } raw_public_key_t;
typedef hash_t unique_data_t;

#define RESTRICTED_MAX_BOOTS (30)
